<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Translatable\HasTranslations;

class Post extends Model
{
    use HasFactory, SoftDeletes ,HasTranslations;
    protected $table = "posts";
    public $translatable = ['name','description'];
    protected $fillable = ['therapist_id','therapist_community_id', 'blog_category_id', 'is_featured', 'name', 'description', 'slug', 'sort_order', 'image', 'is_active','is_community_post', 'deleted_at'];


    public function scopeWithAll($query)
    {
        return $query->with('therapist')->with('tags')->with('therapist_community')->with('blog_category');
    }
    public function scopeWithChildren($query)
    {
        return $query->with('post_comments',function($query){
            $query->withAll()->withChildren();
        })->with('post_likes',function($q){
            $q->liked();
        });
    }

    public function scopeHasModulePermissions($query){
        return $query->whereHas('therapist',function($q){
            $q->whereHas('pricing_plan',function($y){{
                $y->whereHas('therapist_modules',function($z){
                    $z->where('pricing_plan_modules.module_code','therapist-podcasts');
                });
            }});
        })->orWhereHas('therapist_community',function($q){
            $q->whereHas('pricing_plan',function($y){{
                $y->whereHas('therapist_community_modules',function($z){
                    $z->where('pricing_plan_modules.module_code','therapist_community-podcasts');
                });
            }});
        })->doesntHave('therapist', 'or')->doesntHave('therapist_community' , 'or');
    }
    public function scopeActive($query)
    {
        return $query->where('is_active', 1);
    }
    public function scopeCommunitPost($query)
    {
        return $query->where('is_community_post', 1);
    }
    public function scopeFeatured($query)
    {
        return $query->where('is_featured', 1);
    }
    public function therapist()
    {
        return $this->belongsTo(Therapist::class);
    }
    public function therapist_community()
    {
        return $this->belongsTo(TherapistCommunity::class);
    }
    public function blog_category()
    {
        return $this->belongsTo(BlogCategory::class);
    }
    public function tags()
    {
        return $this->belongsToMany(Tag::class, 'post_tag');
    }

    public function post_comments (){
        return $this->hasMany(PostComment::class,'post_id','id')->where('parent_id',null);
    }
    public function post_likes (){
        return $this->hasMany(PostLike::class,'post_id','id');
    }
}
